# delimit ; 
clear; 
clear matrix;
set mem 620m;	
set more 1 ;  
drop _all;
program drop _all;
capture log close;

local elsa=0;

*global folder "C:\Dropbox";
global folder "C:\Users\ebf26\Dropbox";
*global folder "C:\Users\Jeremy\Dropbox";
*global folder "\\econ-san-fs\Home4\uctpkp0\SystemFolder\Windows7\Desktop";

         local saved  "$folder\hrs\merge\";
         local trackd "$folder\hrs\tracker\";
         local wave1d "$folder\hrs\wave1\";
         local wave2d "$folder\hrs\wave2\";
         local wave3d "$folder\hrs\wave3\";
         local wave4d "$folder\hrs\wave4\";
         local wave5d "$folder\hrs\wave5\";
		 local wave6d "$folder\hrs\wave6\";
         local wave7d "$folder\hrs\wave7\";
         local wave8d "$folder\hrs\wave8\";
		 local wave9d "$folder\hrs\wave9\";
		 local wave10d "$folder\hrs\wave10\";
		 local wave11d "$folder\hrs\wave11\";
		 local wave12d "$folder\hrs\wave12\";
		 local wave13d "$folder\hrs\wave13\";
         local aheadw1 "$folder\hrs\aheadw1\";
         local aheadw2 "$folder\hrs\aheadw2\";
         local couples "$folder\hrs\wealthcouples\";



*log using E:\Dropbox\hrs\wealthcouples\dataprep0.log, replace ; 
log using `couples'dataprep_couples0.log, replace ; 

*use `merge'insuranceimpute;
use C:\Users\ebf26\Dropbox\hrs\merge\insuranceimpute;
*use C:\Dropbox\hrs\merge\insuranceimpute;
sum death*;


*use E:\Dropbox\hrs\merge\insuranceimpute;
*use c:\research\hrs\merge\insuranceimpute;
*use C:\Dropbox\hrs\merge\insuranceimpute;

drop if wave>=13;

sum *medcost* *oopd*;


gen elsa=`elsa';
gen firstwave=3;
replace firstwave=6 if elsa==1; * if firstwave=3 -> use data 1996 and later, if firstwave=6 -> use data from 2002 and later;
drop if (wave>RANDwaves & useRAND==1);
drop if (wave>5 & useRAND==0); * DON'T USE FAKE WAVES;
replace realyear=94 if wave==1 & (hrscoh==11|hrscoh==12);
replace realyear=96 if wave==2 & (hrscoh==11|hrscoh==12);
gen temp=wave;
replace temp=wave+1 if (wave==1|wave==2) & (hrscoh==11|hrscoh==12);
replace wave=temp;
* need this fix for the weights;
sort HHID PN wave;
replace wgthh=wgthh[_n-1] if HHID==HHID[_n-1] & PN==PN[_n-1] & (wgthh==0|wgthh==.);
drop if wave<firstwave;

save `couples'dataprep_start, replace;
* save E:\Dropbox\hrs\wealthcouples\dataprep_start, replace;
*save c:\research\hrs\wealthcouples\dataprep_start, replace;



* to create a smaller version of the main dataset, comment out the lines above and uncomment the line below;
*use c:\research\hrs\wealthcouples\dataprep_start;

* first :figure out the dead people;
sort indnum wave;
gen ldead=.;
replace ldead=dead[_n-1] if indnum==indnum[_n-1];
gen lldead=.;
replace lldead=ldead[_n-1] if indnum==indnum[_n-1];
gen llldead=.;
replace llldead=lldead[_n-1] if indnum==indnum[_n-1];
gen lllldead=.;
replace lllldead=llldead[_n-1] if indnum==indnum[_n-1];
gen llllldead=.;
replace llllldead=lllldead[_n-1] if indnum==indnum[_n-1];

replace dead=1 if ldead==1|lldead==1|llldead==1|llldead==1|lllldead==1;
 sort indnum wave dead;
 order indnum wave dead;

/*
drop if hrscoh~=11;
gen counter1=1;
replace counter1=counter1[_n-1]+1 if HHID==HHID[_n-1];
egen count1=sum(counter1) if counter1==1;
sum count*;
exit;
*/


*************************;
* if # of children is missing, use last period's # of children;
sort HHID PN wave;
replace children=children[_n-1] if HHID==HHID[_n-1] & PN==PN[_n-1] & children==.;
gen omwave=1-wave;
sort HHID PN omwave;
replace children=children[_n-1] if HHID==HHID[_n-1] & PN==PN[_n-1] & children==.;
drop omwave;
sort HHID PN wave;


*************************;
* re-code rmarried       ;
* 1 --> married           ;
* 2 --> married, spouse absent;
* 3 --> partnered         ;
* 4 --> separated         ;
* 5 --> divorced          ;
* 6 --> separated/divorced;
* 7 --> widowed           ;
* 8 --> never married     ;
*************************;
* in the program, include the following;
* 0 --> we never observed you;
* 9 --> dead                ;
****************************;

tab rmarried;
replace rmarried =1 if rmarried ==2;
replace rmarried =3 if rmarried ==4;
replace rmarried =5 if rmarried ==6; * set to 3 (drop) or 5 (maybe keep?);

*********************************;
* get more of spouses information;
* I want HOUSEHOLD level information;
*********************************;
* now get information on spouses;
* generate the following variables;
* manmarstat: comprehensive summary measure (has info on whether the individual existed, is alive, is married);
* do the same for women;
* the goal is to have HHID be the unit of observation, rather than HHID and PN; 
* ****************************************;
* manhere, manalive, and manmarried look like garbage;
******************************************;
gen female =1-male;

************************************************;
* date of death for men, women                 *;
************************************************;
replace deathyr=deathyr+deathm/12 if deathm~=.;

gen deathyrman=deathyr if male==1;
gen deathyrwoman=deathyr if male==0;
sort HHID realyear female;
replace deathyrman=deathyrman[_n-1] if HHID==HHID[_n-1] & realyear==realyear[_n-1] & male[_n-1]==1; 
sort HHID realyear male;
replace deathyrwoman=deathyrwoman[_n-1] if HHID==HHID[_n-1] & realyear==realyear[_n-1] & male[_n-1]==0; 


* Men first;
gen manmarstat=0;
replace manmarstat=rmarried if male==1;
sort HHID realyear male;
replace manmarstat=rmarried[_n-1] if HHID==HHID[_n-1] & realyear==realyear[_n-1] & male[_n-1]==1; * this line should not do anything;
sort HHID realyear female;
replace manmarstat=rmarried[_n-1] if HHID==HHID[_n-1] & realyear==realyear[_n-1] & male[_n-1]==1; * this line should do something;

* Women next;
gen womanmarstat=0;
replace womanmarstat=rmarried if male==0;
sort HHID realyear male;
replace womanmarstat=rmarried[_n-1] if HHID==HHID[_n-1] & realyear==realyear[_n-1] & male[_n-1]==0; * this line should do something;
sort HHID realyear female;
replace womanmarstat=rmarried[_n-1] if HHID==HHID[_n-1] & realyear==realyear[_n-1] & male[_n-1]==0; * this line should not do anything;




* this is new--think about what it will do;
* note that rmarried=. if someone drops out of the sample.  I want marstat=0 for these people;
replace manmarstat=0 if manmarstat==.;
replace womanmarstat=0 if womanmarstat==.;


*********note below -- a small handful of cases are being miscoded.  the code will not work when there is a widow co-habiting with someone ********;
* find out if the individual is dead ;
gen mandead=0;
replace mandead=1 if (male==1 & dead==1)|womanmarstat==7; * NOTE: there are about 100 of cases of (male==1 & dead==0) & womanmarstat==7, but only 2 real ones in AHEAD; 
sort HHID realyear male;
replace mandead=1 if HHID==HHID[_n-1] & realyear==realyear[_n-1] & mandead[_n-1]==1; * this line should not do anything;
sort HHID realyear female;
replace mandead=1 if HHID==HHID[_n-1] & realyear==realyear[_n-1] & mandead[_n-1]==1; 

gen womandead=0;
replace womandead=1 if (male==0 & dead==1)|manmarstat==7;
sort HHID realyear male;
replace womandead=1 if HHID==HHID[_n-1] & realyear==realyear[_n-1] & womandead[_n-1]==1; * this line should do something;
sort HHID realyear female;
replace womandead=1 if HHID==HHID[_n-1] & realyear==realyear[_n-1] & womandead[_n-1]==1;  * this line should not do anything;

* your marstat=9 if you are dead, by definition;
replace womanmarstat=9 if womandead==1;
replace manmarstat=9 if mandead==1;

tab manmarstat womanmarstat;
drop female;

*********************************************;
* use spouses info if you are missing        ;
*********************************************;
replace manmarstat=1 if manmarstat==0 & womanmarstat==1;
replace womanmarstat=1 if womanmarstat==0 & manmarstat==1;

replace manmarstat=7 if (manmarstat==1| manmarstat==3| manmarstat==5| manmarstat==8) & womanmarstat==9;
replace womanmarstat=7 if (womanmarstat==1| womanmarstat==3| womanmarstat==5| womanmarstat==8) & manmarstat==9;


**********************************************;
* reduce the state space                      ;
**********************************************;
replace manmarstat=3 if (manmarstat==0) & womanmarstat==3;
*replace manmarstat=5 if (manmarstat==0) & womanmarstat==5;
replace womanmarstat=3 if (womanmarstat==0) & manmarstat==3;
*replace womanmarstat=5 if (womanmarstat==0) & manmarstat==5;

tab manmarstat womanmarstat;



****************************************;
* code up everything to do with the lags;
* get rid of people (or re-code) if they have;
* nonsensical transitions or transitions that are outside the model;
****************************************;

****************************************;
* men first                             ;
****************************************;

gen omwave=10-wave;
*sort HHID PN omwave;
*replace manmarstat=9 if manmarstat==0 & manmarstat[_n-1]==9 & HHID==HHID[_n-1] & PN==PN[_n-1];
sort HHID PN wave;
replace manmarstat=9 if manmarstat==0 & manmarstat[_n-1]==9 & HHID==HHID[_n-1] & PN==PN[_n-1];
replace manmarstat=5 if (manmarstat==7|manmarstat==8) & manmarstat[_n-1]==5 & HHID==HHID[_n-1] & PN==PN[_n-1];
replace manmarstat=7 if (manmarstat==5|manmarstat==8) & manmarstat[_n-1]==7 & HHID==HHID[_n-1] & PN==PN[_n-1];

replace manmarstat=7 if womanmarstat==9 & (manmarstat~=9 & manmarstat~=0);


* figure out who of the divorced people were divorced in wave 1;
* (and thus we treat as a single) and who gets divorced ;
* (in which case we drop them);
gen mangotdivorced=0;
gen mangotmarried=0;
sort HHID PN wave;
replace mangotdivorced=1 if manmarstat[_n-1]~=5 & manmarstat==5 & HHID==HHID[_n-1] & PN==PN[_n-1];
replace mangotmarried=1 if manmarstat[_n-1]~=1 & manmarstat==1 & HHID==HHID[_n-1] & PN==PN[_n-1];

*********************************;
*                      now women ;
*********************************;

*sort HHID PN omwave;
*replace womanmarstat=9 if womanmarstat==0 & womanmarstat[_n-1]==9 & HHID==HHID[_n-1] & PN==PN[_n-1];
sort HHID PN wave;
replace womanmarstat=9 if womanmarstat==0 & womanmarstat[_n-1]==9 & HHID==HHID[_n-1] & PN==PN[_n-1];
replace womanmarstat=5 if (womanmarstat==7|womanmarstat==8) & womanmarstat[_n-1]==5 & HHID==HHID[_n-1] & PN==PN[_n-1];
replace womanmarstat=7 if (womanmarstat==5|womanmarstat==8) & womanmarstat[_n-1]==7 & HHID==HHID[_n-1] & PN==PN[_n-1];

replace womanmarstat=7 if manmarstat==9 & (womanmarstat~=9 & womanmarstat~=0);



* figure out who of the divorced people were divorced in wave 2;
* (and thus we treat as a single) and who gets divorced ;
* (in which case we drop them);
gen womangotdivorced=0;
gen womangotmarried=0;
sort HHID PN wave;
replace womangotdivorced=1 if womanmarstat[_n-1]~=5 & womanmarstat==5 & HHID==HHID[_n-1] & PN==PN[_n-1];
replace womangotmarried=1 if womanmarstat[_n-1]~=1 & womanmarstat==1 & HHID==HHID[_n-1] & PN==PN[_n-1];


***************************************;
* code up drops here                   ;
***************************************;
sort HHID PN wave;
gen lmanmarstat=manmarstat[_n-1] if HHID==HHID[_n-1] & PN==PN[_n-1];
gen lwomanmarstat=womanmarstat[_n-1] if HHID==HHID[_n-1] & PN==PN[_n-1];

tab lmanmarstat manmarstat;
tab lwomanmarstat manmarstat;
drop lmanmarstat lwomanmarstat;


* First, get rid of housholds who split up (divorce, etc.);
gen dumpthis=0;
replace dumpthis=1  if (sub2w2~=0 & sub2w2~=.)|(sub3w3~=0 & sub3w3~=.);
replace dumpthis=1  if (sub4w4~=0 & sub4w4~=.)|(sub5w5~=0 & sub5w5~=.)|(sub6w6~=0 & sub6w6~=.);
replace dumpthis=1  if (sub7w7~=0 & sub7w7~=.)|(sub8w8~=0 & sub8w8~=.)|(sub9w9~=0 & sub9w9~=.)|(sub10w10~=0 & sub10w10~=.);




* Also, get rid of households with two or more members of the same sex;
* this is about 1/2% of the AHEAD sample--seems to be associated with deaths;
* (wife #1 dies, man hitches up with #2, and there is a placeholder for #2 the whole way along);
sort HHID wave male;
replace dumpthis=2 if HHID==HHID[_n-1] & wave==wave[_n-1] & male==male[_n-1];
replace dumpthis=2 if HHID==HHID[_n+1] & wave==wave[_n+1] & male==male[_n+1];
tab dumpthis;








* get rid of people who are "separated" and "partnered";
gen dumpthis0=0;
replace dumpthis0=3 if manmarstat==3;
replace dumpthis0=3 if womanmarstat==3;
*get rid of people who got divorced or married;
gen dumpthis1=0;
replace dumpthis1=1 if mangotdivorced==1|mangotmarried==1;
replace dumpthis1=1 if womangotdivorced==1|womangotmarried==1;
* get rid of people who "died", then came back to life;
sort HHID PN wave;
gen dumpthis2=0;
replace dumpthis2=1 if manmarstat[_n-1]==9 & manmarstat~=9 & HHID==HHID[_n-1] & PN==PN[_n-1];
replace dumpthis2=1 if womanmarstat[_n-1]==9 & womanmarstat~=9 & HHID==HHID[_n-1] & PN==PN[_n-1];
* one spouse is dead, the other claims to be divorced;
gen dumpthis3=0;
replace dumpthis3=1 if manmarstat==5 & womanmarstat[_n-1]==9 & HHID==HHID[_n-1] & PN==PN[_n-1];
replace dumpthis3=1 if womanmarstat==5 & manmarstat[_n-1]==9 & HHID==HHID[_n-1] & PN==PN[_n-1];
* one spouse claims to not be married this year, claims something else last year;
gen dumpthis4=0;
replace dumpthis4=1 if manmarstat==0 & manmarstat[_n-1]~=0 & HHID==HHID[_n-1] & PN==PN[_n-1];
replace dumpthis4=1 if womanmarstat==0 & womanmarstat[_n-1]~=0 & HHID==HHID[_n-1] & PN==PN[_n-1];


replace dumpthis=1 if dumpthis~=0;
egen num=sum(dumpthis), by (HHID);

replace dumpthis0=1 if dumpthis0~=0;
egen num0=sum(dumpthis0), by (HHID);

replace dumpthis1=1 if dumpthis1~=0;
egen num1=sum(dumpthis1), by (HHID);

replace dumpthis2=1 if dumpthis2~=0;
egen num2=sum(dumpthis2), by (HHID);

replace dumpthis3=1 if dumpthis3~=0;
egen num3=sum(dumpthis3), by (HHID);

replace dumpthis4=1 if dumpthis4~=0;
egen num4=sum(dumpthis4), by (HHID);

****************************************************************;
* think through the two lines below--I think they are OK        ;
* when mar_stat_drop=1, but I am not sure about otherwise       ;
* I think it is OK under all circumstances, but caveat emptor,  ;
* future self                                                   ;
****************************************************************;
*replace manmarstat=0 if (manmarstat==5 & womanmarstat==5 & male==0); * set to 0 for divorced females;
*replace womanmarstat=0 if (manmarstat==5 & womanmarstat==5 & male==1); * set to 0 for divorced males;



* get the initial household structure;
* men;
sort indnum wave;
gen lmanmarstat=.;
replace lmanmarstat=manmarstat[_n-1] if indnum==indnum[_n-1];
gen llmanmarstat =.;
replace llmanmarstat = lmanmarstat[_n-1] if indnum==indnum[_n-1];
gen lllmanmarstat =.;
replace lllmanmarstat =llmanmarstat[_n-1] if indnum==indnum[_n-1];
gen llllmanmarstat =.;
replace llllmanmarstat =lllmanmarstat[_n-1] if indnum==indnum[_n-1];
gen lllllmanmarstat=.;
replace lllllmanmarstat =llllmanmarstat[_n-1] if indnum==indnum[_n-1];
gen llllllmanmarstat=.;
replace llllllmanmarstat =lllllmanmarstat[_n-1] if indnum==indnum[_n-1];
gen lllllllmanmarstat=.;
replace lllllllmanmarstat =llllllmanmarstat[_n-1] if indnum==indnum[_n-1];
gen llllllllmanmarstat=.;
replace llllllllmanmarstat =lllllllmanmarstat[_n-1] if indnum==indnum[_n-1];
gen lllllllllmanmarstat=.;
replace lllllllllmanmarstat =llllllllmanmarstat[_n-1] if indnum==indnum[_n-1];
gen llllllllllmanmarstat=.;
replace llllllllllmanmarstat =lllllllllmanmarstat[_n-1] if indnum==indnum[_n-1];


*women;
sort indnum wave;
gen lwomanmarstat=.;
replace lwomanmarstat=womanmarstat[_n-1] if indnum==indnum[_n-1];
gen llwomanmarstat =.;
replace llwomanmarstat = lwomanmarstat[_n-1] if indnum==indnum[_n-1];
gen lllwomanmarstat =.;
replace lllwomanmarstat =llwomanmarstat[_n-1] if indnum==indnum[_n-1];
gen llllwomanmarstat =.;
replace llllwomanmarstat =lllwomanmarstat[_n-1] if indnum==indnum[_n-1];
gen lllllwomanmarstat =.;
replace lllllwomanmarstat =llllwomanmarstat[_n-1] if indnum==indnum[_n-1];
gen llllllwomanmarstat =.;
replace llllllwomanmarstat =lllllwomanmarstat[_n-1] if indnum==indnum[_n-1];
gen lllllllwomanmarstat =.;
replace lllllllwomanmarstat =llllllwomanmarstat[_n-1] if indnum==indnum[_n-1];
gen llllllllwomanmarstat =.;
replace llllllllwomanmarstat =lllllllwomanmarstat[_n-1] if indnum==indnum[_n-1];
gen lllllllllwomanmarstat =.;
replace lllllllllwomanmarstat =llllllllwomanmarstat[_n-1] if indnum==indnum[_n-1];
gen llllllllllwomanmarstat =.;
replace llllllllllwomanmarstat =lllllllllwomanmarstat[_n-1] if indnum==indnum[_n-1];


tab hrscoh;

tab lmanmarstat manmarstat;
tab lwomanmarstat manmarstat;


* first observed household structure;
gen firstman=.;
replace firstman=manmarstat if wave==firstwave;
replace firstman =lmanmarstat if wave==firstwave+1;
replace firstman =llmanmarstat if wave==firstwave+2;
replace firstman =lllmanmarstat if wave==firstwave+3;
replace firstman =llllmanmarstat if wave==firstwave+4;
replace firstman =lllllmanmarstat if wave==firstwave+5;
replace firstman =llllllmanmarstat if wave==firstwave+6;
replace firstman =lllllllmanmarstat if wave==firstwave+7;
replace firstman =llllllllmanmarstat if wave==firstwave+8;
replace firstman =lllllllllmanmarstat if wave==firstwave+9;



gen firstwoman=.;
replace firstwoman=womanmarstat if wave==firstwave;
replace firstwoman =lwomanmarstat if wave==firstwave+1;
replace firstwoman =llwomanmarstat if wave==firstwave+2;
replace firstwoman =lllwomanmarstat if wave==firstwave+3;
replace firstwoman =llllwomanmarstat if wave==firstwave+4;
replace firstwoman =lllllwomanmarstat if wave==firstwave+5;
replace firstwoman =llllllwomanmarstat if wave==firstwave+6;
replace firstwoman =lllllllwomanmarstat if wave==firstwave+7;
replace firstwoman =llllllllwomanmarstat if wave==firstwave+8;
replace firstwoman =lllllllllwomanmarstat if wave==firstwave+9;





*********************end of household structure coding;

* next: generate birthyear dummies;
*drop if age<65|age>110;




tab birthyr;
gen cohort=.;
replace cohort=-3 if birthyr>1943 & birthyr<1949;
replace cohort=-2 if birthyr>1938 & birthyr<1944;
replace cohort=-1 if birthyr>1933 & birthyr<1939;
replace cohort=0 if birthyr>1928 & birthyr<1934;
replace cohort=1 if birthyr>1923 & birthyr<1929;
replace cohort=2 if birthyr>1918 & birthyr<1924;
replace cohort=3 if birthyr>1913 & birthyr<1919;
replace cohort=4 if birthyr>1908 & birthyr<1914;
replace cohort=5 if birthyr>1903 & birthyr<1909;
replace cohort=6 if birthyr>1898 & birthyr<1904;
replace cohort=7 if birthyr>1893 & birthyr<1899;
replace cohort=8 if birthyr>1888 & birthyr<1894;



* give women their husband’s cohort;
gen female=1-male;
sort HHID realyear female;
replace cohort=cohort[_n-1] if HHID==HHID[_n-1] & realyear==realyear[_n-1];
* make sure all women remain in the same cohort;
sort HHID PN realyear;
replace cohort=cohort[_n-1] if HHID==HHID[_n-1] & PN==PN[_n-1];



* adjusted age-average age of individuals in your birthyear cohort in a year;
gen agej=47 if cohort==-3;
replace agej=52 if cohort==-2;
replace agej=57 if hrscoh==-1; //bug?
replace agej=62 if cohort==0;
replace agej=67 if cohort==1;
replace agej=72 if cohort==2;
replace agej=77 if cohort==3;
replace agej=82 if cohort==4;
replace agej=87 if cohort==5;
replace agej=92 if cohort==6;
replace agej=97 if cohort==7;

replace agej=agej+1;

replace agej=agej+2 if wave==3;
replace agej=agej+4 if wave==4;
replace agej=agej+6 if wave==5;
replace agej=agej+8 if wave==6;
replace agej=agej+10 if wave==7;
replace agej=agej+12 if wave==8;
replace agej=agej+14 if wave==9;


tab firstman firstwoman;
tab manmarstat womanmarstat;


gen firsthh=0;
replace firsthh=1 if (firstwoman==5|firstwoman==7|firstwoman==8);
replace firsthh=2 if (firstman==5|firstman==7|firstman==8);
replace firsthh=3 if (firstman==1);
replace firsthh=3 if (firstwoman==1);

tab firsthh;




* this program generates age dummies;
program define genages;
        version 3.1;
sum age;
local i = 45 ;
while `i' <=96 { ;	
	gen age`i'=0;
	replace age`i'=1 if age==`i';
	local i = `i'+1 } ;
end;
set trace off ;
genages;

*gen numwaves=4+useRAND;
gen numwaves=RANDwaves-1;

* this program generates time dummies;
program define gentime;
        version 3.1;
tab wave;
local i = 1 ;
while `i' <=numwaves { ;	
	gen time`i'=0;
	replace time`i'=1 if wave==(`i'+1);
	local i = `i'+1 } ;
end;
set trace off ;
gentime;
sum time*;
drop numwaves;

*************************************;
* re-coded manmarstat, womanmarstat  ;
* 0 --> not in sample (spouse never married, spouse is dead) ;
* 1 --> married                      ;
* 5 --> divorced                     ;
* 7 --> widowed                      ;
* 8 --> never married                ;
* 9 --> dead                          ;
*************************************;
tab manmarstat womanmarstat;
gen died=.;
replace died=0 if male==0 & (womanmarstat>0 & womanmarstat<9);
replace died=0 if male==1 & (manmarstat>0 & manmarstat<9);
replace died=1 if male==0 & womanmarstat==9;
replace died=1 if male==1 & manmarstat==9;

tab dead died;

***************************************;
* this is to "annualize" medical spending for those who die :);

replace oopd=oopd/2 if died==1;
replace medcost=medcost/2 if died==1;







sort HHID realyear male;
save `couples'dataprep0, replace;
*save c:\research\hrs\wealthcouples\dataprep0, replace;

drop _all;
program drop _all;
log close;



